<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="destination.css">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <script src="https://kit.fontawesome.com/90b556f99d.js" crossorigin="anonymous"></script>
    <link href="https://fonts.googleapis.com/css2?family=Nova+Square&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="shortcut icon" href="img/favicon.webp">
    <title>Destinations</title>
</head>
<body>
    <section class="header">
        <nav class="navbar">
                <li class="logo"><a = href="accueil.php" class="logo"><img src="img/Resa.png" alt="acceuil RésaKingdom"></a></li>
                    <div class="bordureShearch flexCentre">
                    <input type="text" class="search" placeholder="Rechercher" id="search">
                <div class="nav-links">
                    <ul>
                    <li><a href="index.php" alt="Accueil RésaKingdom">Accueil</a></li>
                    <li><a href="#" class="active">Réserver</a></li>
                    </ul>
        </nav>
        <div class="sombre">
                <h1 data-aos="fade-up">Réserver</h1>
                <h2 data-aos="fade-down">N'attendez plus et partez pour les mondes dès maintenant !</h2>
                <span class="auto-typing" data-aos="fade-up"></span>
        </div>
    </section>
    <section class="destination" data-aos="fade-up">
            <h2>Réserver nos destination</h2>
            <?php
            include 'conn.php';
            ?>

        <div class="container">
        <?php
        $requete="SELECT * FROM rek_destination";
        $stmt=$db->query($requete);
        $result=$stmt->fetchall(PDO::FETCH_ASSOC);

        foreach ($result as $destination){
            echo "<div class='boite' data-aos='fade-down'>";
            echo "<h2 data-aos='fade-up'>{$destination["nom"]}</h2>";
            echo "<img src='{$destination["img"]}' alt='image d'illustration de la destination' data-aos='flip-right'>";
            echo "<details>";
            echo "<summary>Description</summary>";
            echo "<p>{$destination["description"]}</p>";
            echo "</details>";
            echo "<a href='reserv.php/destination={$destination["id_destination"]}' class='btn'>Réservez</a>";
            echo "</div>";
        }
        ?>
        </div>
    </section>
<footer>

</footer>

</body>

<script src="script.js"></script>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script>
    AOS.init();
</script>

<script src="https://unpkg.com/typed.js@2.1.0/dist/typed.umd.js"></script>
    <script>
        let typed = new Typed('.auto-typing', {
            strings: ['aux Iles du destin','à la Citée du Crépuscule', 'au Chateau Disney', 'au Colisée de L\'Oympe', 'au Jardin Radieux', 'à la Ville de Traverse',],
            typeSpeed: 100,
            backSpeed: 100,
            loop: true,
            fadeOut: true,
            fadeOutClass: 'typed-fade-out',
            fadeOutDelay: 500,
            shuffle: true
        })
    </script>

</html>