<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/expo/css/style.css">
    <link rel="shortcut icon" href="/expo/img/logo.svg" type="image/svg">
    <link href="https://fonts.googleapis.com/css2?family=Courier+Prime:wght@400;700&display=swap" rel="stylesheet">
    <title>Expo-Elizebeth_Friedman Profil utilisateur</title>
</head>
<body>
    <header>
        <nav>
            <div class="link_group">
                <a href="https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=deconn">Déconnexion</a></a>
                <a href="index.php?action=reservation">Réserver</a>
            </div>
            <img src="/expo/img/logo.svg" alt="logo">
            <button><a href="english/index.php?action=profile">EN</a></button>
        </nav>
    </header>
   <?php
if (isset($_SESSION['login']) && isset($_SESSION['user_id']) && !empty($_SESSION['login']) && !empty($_SESSION['user_id'])) {
?>

<main>
<h1>Profil</h1>

<h2>Vos informations</h2>

<p>Ce formulaire regroupe toutes les informations relatives à votre compte. Vous avez la possibilité de modifier intégralement vos données personnelles, y compris votre nom, votre adresse e-mail, votre mot de passe et toute autre information associée à votre compte. Assurez-vous que vos informations sont toujours à jour pour garantir une expérience optimale.</p>

<div class="form-container">
    <form method="POST">
        <h2>Modification de profil</h2>
        <p>Tous les champs sont obligatoire</p>
        <?php
            echo "
            <input type='hidden' name='user_id' value='" . $_SESSION['user_id'] . "'>

            <div class='input-group'>
                <label for='email'>Changer votre adresse mail</label>
                <input type='email' id='email' name='email' value='" . $_SESSION['login'] . "'>
            </div>

            <div class='input-group'>
                <label for='nom'>Changer votre nom</label>
                <input type='text' id='nom' name='nom' value='" . $_SESSION['nom'] . "'>
            </div>

            <div class='input-group'>
                <label for='prenom'>Changer votre prénom</label>
                <input type='text' id='prenom' name='prenom' value='" . $_SESSION['prenom'] . "'>
            </div>

            <div class='input-group'>
                <label for='mdp'>Changer votre mot de passe</label>
                <input type='password' id='mdp' name='mdp'>
            </div>

            <input type='submit' value='validez' class='bouton'>
            ";
        ?>
    </form>
</div>

<h2>Vos réservations</h2>

<p>Dans ce tableau, vous pouvez retrouver toutes les réservations liées à votre compte. Il est possible de consulter et de gérer vos réservations, y compris la possibilité de supprimer celles que vous ne souhaitez plus conserver. Assurez-vous de maintenir votre liste à jour en supprimant les réservations indésirables.</p>

<table width="100%" border="1" cellspacing="0" cellpadding="8" align="center" style="border-collapse: collapse;">
                <tr align="center">
                    <th>Exposition</th>
                    <th>Date</th>
                    <th>Heure</th>
                    <th>Nombre de personne</th>
                    <th>Supprimer</th>
                </tr>
<?php
//récupération des tickets par utilisateurs
$ch = curl_init("https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=ticket&user_id=". $_SESSION['user_id'] ."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true) ?? [];

if (!isset($data['status'])) {
    echo "<p>Erreur : Réponse invalide du serveur</p>";
    exit;
}

if ($data['status'] === 200 && isset($data['tickets'])) {
    foreach ($data['tickets'] as $ticket) {
        echo "
        <tr align='center'>
            <td>{$ticket['expo_nom']}</td>
            <td>{$ticket['date']}</td>
            <td>{$ticket['heure']}</td>
            <td>{$ticket['nb_ticket']}</td>
            <td><button onclick='deleteTicket({$ticket['id']})' class='bouton'>Supprimer</button></td>
        </tr>
        ";
    }
} else {
    echo "<p>{$data['message']} Pourquoi ne pas réserver une séance ?<a href='https://nkodiadiabate.butmmi.o2switch.site/expo/index.php?action=reservation'>Réservez</a></p>";
}

// Modifier le profil
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $ch = curl_init("https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=modify_user");

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");

    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);

    $data_to_send = [
        'user_id' => $_SESSION['user_id'],
        'email' => $_POST['email'],
        'nom' => $_POST['nom'],
        'prenom' => $_POST['prenom'],
        'mdp' => $_POST['mdp']
    ];

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_to_send));

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true) ?? [];

    if (!isset($data['status'])) {
        echo "<p>Erreur : Réponse invalide du serveur</p>";
        exit;
    }

    if ($data['status'] === 200) {
        echo "Vos informations ont bien été modifiées. Reconnecter-vous pour voir les informations à jour";
    } else {
        echo "<p>Erreur : {$data['message']}</p>";
    }
}
?>
</table>
</main>
<?php
} else {
    echo 'Vous devez être connecté pour voir cette page.';
}
   ?>
<script>
    function deleteTicket(id) {
    fetch(`https://nkodiadiabate.butmmi.o2switch.site/expo/api/index.php?action=supr_ticket&id=${id}`, {
        method: "DELETE"
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        location.reload();
    })
    .catch(error => console.error("Erreur :", error));
}
</script>
</body>
</html>